#!/usr/bin/env python
# encoding: utf-8

import pylab as pl
import netCDF4 as nc

D = nc.Dataset("tccon-data/tk20110804_20160330.public.nc")
pl.hexbin(D.variables["wdir_deg"][:], (D.variables["time"][:]+9/24.)%1 * 24, # alpha=0.01,
          label="wind direction vs. time of day",
          linewidth=0.1) # avoid overlapping hexes
pl.axhline(11, linewidth=4, color="k", alpha=0.5, label="dense area, lower limit")
pl.axhline(16, linewidth=4, color="k", alpha=0.5, label="dense area, upper limit")
# pl.legend()
pl.title("wind direction vs. time of day in Tsukuba, Japan")
pl.xlabel("wind direction / degree")
pl.ylabel("time of day / localtime")
pl.colorbar().set_label("count")
pl.savefig("tsukuba-wind-direction-vs-time-of-day.pdf")
