import csv
import os
import pickle
import copy
import pandas as pd
import re 
import xlrd
import math
from datetime import datetime   
from scipy.stats import norm 
import seaborn as sns 
from PIL import Image
from __future__ import print_function
import keras
from keras.layers import Dense, Flatten
from keras.layers import Conv2D, MaxPooling2D
from keras.layers import Dropout, Activation
from keras.layers.normalization import BatchNormalization
from keras.models import Sequential
import matplotlib.pylab as plt
from keras.models import load_model
import random
from random import shuffle
from keras.callbacks import TensorBoard
from keras.callbacks import ModelCheckpoint
from keras import backend as K
from keras.utils import multi_gpu_model
import numpy as np
import tensorflow as tf
import time

import os
os.environ["CUDA_DEVICE_ORDER"]="PCI_BUS_ID" 
os.environ["CUDA_VISIBLE_DEVICES"]="0" 

# .csv Reader 
def csvimport(file_name):
    smiles = []
    with open(file_name) as csvfile:
        csv_reader = csv.reader(csvfile)
        for row in csv_reader: 
            smiles.append(row)
    return(smiles)

    # Model Construction
    # Upgrade 1: Previous heatmap study indecated that the CNN did not utilize convolution layer 4 (no gradiant observed for POPs), 
    # thus the improved CNN model abandons the 4th layer.


def modelconstruction():
      # Model construction
      # Model 3
      model3 = Sequential()
      model3.add(Conv2D(256, kernel_size=(3, 3), padding='same',
                        activation='relu', input_shape=input_shape))
      model3.add(Conv2D(256, kernel_size=(5, 5), padding='same',
                        activation='relu', input_shape=input_shape))
      model3.add(MaxPooling2D(pool_size=(2, 2)))

      model3.add(Dropout(0.2))

      model3.add(Conv2D(128, kernel_size=(3, 3), padding='same',
                        activation='relu', input_shape=input_shape))
      model3.add(MaxPooling2D(pool_size=(2, 2)))

      model3.add(Conv2D(64, kernel_size=(3, 3), padding='same',
                        activation='relu', input_shape=input_shape))
      model3.add(MaxPooling2D(pool_size=(2, 2)))

      model3.add(Dropout(0.2))

      model3.add(Conv2D(64, kernel_size=(3, 3), padding='same',
                        activation='relu', input_shape=input_shape))

      model3.add(Dropout(0.2))

      model3.add(Flatten())
      model3.add(Dense(1000, activation='sigmoid'))
      model3.add(Dense(num_classes, activation='softmax'))


      model3.compile(loss=keras.losses.binary_crossentropy,
                     optimizer=keras.optimizers.SGD(lr=0.01),
                     metrics=['accuracy'])
      return (model3)


def get_im(paths, filenames, img_rows, img_cols, color_type, normalize=True):
      # Load as grayscale
      imgs = []
      for n in range(len(filenames)):
            if color_type == 1:
                  img = Image.open(paths[n] + filenames[n], 0)
            elif color_type == 3:
                  img = Image.open(paths[n] + filenames[n])

            im = img.resize((img_rows, img_cols), Image.ANTIALIAS)  # Image.ANTIALIAS缩略图
            im = np.array(im)

            if normalize:
                  im = im.astype('float32')
                  #             im = im/255
                  im /= 127.5 
                  im -= 1. 

            imgs.append(im)

      return np.array(imgs).reshape(len(filenames), img_rows, img_cols, color_type)


def get_lb(y_data):
      labels = []
      for i in range(len(y_data)):
            if y_data[i] == 0:
                  labels.append([1, 0])
            else:
                  labels.append([0, 1])

      labels = np.array(labels)

      return labels


# Data_Preprocessing

def get_train_batch(datalist, batch_size, img_w, img_h, color_type):
      x_data = []
      y_data = []
      path_p = []
      for i in range(len(datalist)):
            x_data.append(datalist[i][2])
            y_data.append(int(datalist[i][1]))
            path_p.append(datalist[i][0])

      while 1:
            for i in range(0, len(datalist), batch_size):
                  x = get_im(path_p[i:i + batch_size], x_data[i:i + batch_size], img_w, img_h, color_type)
                  y = get_lb(y_data[i:i + batch_size])
                  yield ({'conv2d_1_input': x}, {'dense_2': y})


def modeltraining(model, modelname, batch_size, epochs, num_classes, img_w, img_h, color_type, trainlist, vallist):
      print('Now start the next model training process!')

      # Model Training

      checkpoint = ModelCheckpoint(filepath=modelname, monitor='val_acc', mode='auto', save_best_only='True')

      model.fit_generator(generator=get_train_batch(trainlist, batch_size, img_w, img_h, color_type),
                          steps_per_epoch=len(trainlist) // batch_size + 1,
                          epochs=epochs, verbose=1,  
                          validation_data=get_train_batch(vallist, batch_size, img_w, img_h, color_type),
                          validation_steps=len(vallist) // batch_size + 1,
                          callbacks=[checkpoint])

      model.summary()

# Data Import

path = r'E:/typhoon_image_data/'

trainlist_file = path + 'Train.csv'
vallist_file = path + 'Val.csv'
testlist_file = path + 'Test.csv'

trainlist = csvimport(trainlist_file)
vallist = csvimport(vallist_file)
testlist = csvimport(testlist_file)

# weight_file_dir = 'E:\\typhoon image data\\Tdata\\Intensitymodel.h5'
# model = load_model(weight_file_dir)

modelname = 'E:/typhoon_image_data/TC-fivefold.h5'
path_train = r'E:/typhoon_image_data/Training/'
path_val = r'E:/typhoon_image_data/Validating/'
batch_size = 64
epochs = 80
num_classes = 2
img_w = 100
img_h = 100
color_type = 3
input_shape = (img_w, img_h, color_type)

# Model Generation
model_test = modelconstruction()

# Model Evaluation
modeltraining(model_test,modelname,batch_size,epochs,num_classes,img_w,img_h,color_type,trainlist,vallist)