function y = apply_nn(x)

    nn = load('nn_coefficients.mat').nn;
    
    x = xnormalization(nn,x);
    y = nnet_forward(nn,x);
    y = unnormalization(y,nn.ymin,nn.ymax);

end

function out = xnormalization(nn,in)

    inmin = nn.xmin;
    inmax = nn.xmax;
  
    xn    = 2 * bsxfun(@minus,in,inmin);
    xr    = inmax - inmin;
    out   = bsxfun(@rdivide,xn,xr) - 1;
  
end

function y = nnet_forward(nn,x) 
  
    [~,y] = nnet_forward_private(nn,x);  

end

function [a1,a2] = nnet_forward_private(nn,x)

    n  = bsxfun(@plus,nn.w1*x,nn.b1);
    a1 = 2 ./ (1 + exp(-2*n)) - 1;
    n  = bsxfun(@plus,nn.w2*a1,nn.b2);
    a2 = n;
  
end

function out = unnormalization(in,inmin,inmax)
  
    r   = inmax - inmin;
    n   = 0.5 * bsxfun(@times,in+1,r);
    out = bsxfun(@plus,n,inmin);
  
end