### ******************************************************************************
### *********************** Swiss miniDOAS data evaluation ***********************
### **************************** for post-processing *****************************
### *************** raw data recorded by Agroscope LabView program - *************
### **** this script works with Swiss miniDOAS data recorded from Jan.2014 on ****
### *************************** author: Joerg Sintermann *************************
### ******************************************************************************

### details see: Sintermann, J., Dietrich, K., Häni, C., Bell, M., Jocher, M., and Neftel, A.: A miniDOAS instrument optimised for ammonia field-measurements, Atmos. Meas. Tech. Discuss., doi:10.5194/amt-2015-360, in review, 2016.
### this evaluation requires several R-scripts, miniDOAS measurement data files with a fixed structure and a certain folder structure
### see associated README.txt
### it is recommended to use this script on x64 machines for evaluation of > 2 days; I recommend to limit the data evaluation to maximum one month at once, I don't really know when real and virtual memory is killed by these calculations. With averaging spectra to longer intervals before evaluation ('average.rawdat'), it will be possible to accelerate the evaluation
### required R libraries: see "miniDOAS_packages.R"

rm(list=ls())
program.version <- "v5.0 (15.02.2016)"


################################################################################
### input parameter ############################################################
################################################################################


### evaluation period
evalperiod <- c("19.05.2015", "19.05.2015")                                        ### c(startdate, enddate) with the format "%d.%m.%Y"
eval_timezone <- "UTC"

### DOAS model
DOAS.model <- "S5"                                                                 ### S1 to S5

### total path length
path.length <- 2 * 37.2 + 1.4                                                      ### (full) measurement path length [m] (about 1.4 m path happens inside the miniDOAS box)

### file directories
directory <- "/Users/Sinti/ownCloud/Arbeit/Programming/R/Projects/DOAS/miniDOAS_Revaluation_basic_version"  ### default directory: separator = "/" or "\\" instead of "\"; calculation results will be saved in ".../2_Results"
reference.dir <- "miniDOAS-ref_cal_spec-Eval201602170000"                          ### sub-directory of reference files (give path below ".../1_Reference_Spectra/" level); folder directory of average reference lamp-, dark-, and calibration spectra (optionally fixed pattern); these have to be created using "1_miniDOAS_average_refspecs.R"
eval.dir <- "/Users/Sinti/ownCloud/Arbeit/Programming/R/Projects/DOAS/miniDOAS_Revaluation_basic_version/miniDOAS_Revaluation"  ### function collection: should contain the file "miniDOAS functions.r" etc

### average raw spectra (either for real, or for plotting only)
avg.period <- 30                                                                   ### minutes
average.rawdat <- TRUE                                                             ### whether to average raw spectra before calculation (TRUE) or to process all raw spectra individually (FALSE)


################################################################################
### setup ######################################################################
################################################################################


### directories
### ******************************************************************************
cat("directories")
save.dir <- paste0(directory,"/2_Results")                                		### directory where to save all results (in a separate new folder)
reference.dir <- paste0(directory,"/1_Reference_Spectra/",reference.dir)  		### folder directory of averaged reference spectra
rawdata.dir <- paste0(directory,"/0_Measurement_Data")
setwd(directory)
avg.refspecs <- FALSE

### parameters, packages & functions
### ******************************************************************************
source(paste0(eval.dir,"/miniDOAS_setupeval.R"))


################################################################################
### data evaluation ############################################################
################################################################################


source(paste0(eval.dir,"/miniDOAS_maincode.R"))
# now here you can modify evalperiod and then call
# source(paste0(eval.dir,"/miniDOAS_setupeval.R")); source(paste0(eval.dir,"/miniDOAS_maincode.R"))
# again to set up more evaluations sequentially


################################################################################
################################################################################
################################################################################




