### additional evaluation parameters and options (these are recommended settings)
### ******************************************************************************
### main evaluation strategy
filter.type <- "rfbaseline.smooth"  											   ### currently "rfbaseline.smooth" = smoothed (loess) REBS local polynomial fitting with one-sided outlier weighting, or "loess" (= local polynomial fitting), "doubleAVG" (= twice a 2-sided moving average, forth and back); will be applied to all: calibration differential spectrum and measurement differential spectrum
fit.type <- "arima"                                                                ### "arima" | "lm"
max.order <- list(p=2, d=0, q=2)                                                   ### maximum orders for the arima model (see ?arima) - fitting is iterated over all order combinations and best model is selected by AICc; if max.order == NULL & fit.type == "arima", default orders (see functions) will be used without model selection; will be ignored for lm
straylight.offset <- TRUE
corr.shift <- TRUE                                                                 ### whether to consider a shift in ccd pixels at all
tau.shift <- 1                                                                     ### number of +-pixel for shifting spectra against each other to minimise residuals in the fitting procedure; tau.shift can be NA, then no shifting is considered; tau.shift cannot be larger than half of filter.strength
tau.divisor <- 1                                                                   ### whether to derive the average fixed residual pattern spectrum

### fixed pattern correction
corr.fixed.pattern <- FALSE                                                        ### whether to consider an averaged fixed (not-random) noise pattern spectrum (evaluated as moving averaged residual spectrum)
fixed.pattern.length <- 3*24												       ### hours

### plotting evaluation details
plot.results <- TRUE                                                               ### avg.period = overall averaging period [min] for plotting (or averaging, if average.rawdat == TRUE) of spectra ensemble (can be NA, then no plot is produced)
calref.cols <- c("blue", "green", "orange", "cyan")

### determine measurement data file(s)
cat("\ndetermine measurement data files")
if (avg.refspecs) {
    evalperiod <- list(time.dark, time.ref, time.ref.dark, time.NH3.cal, time.SO2.cal, time.NO.cal, time.N2.cal, time.N2.dark.cal)
    evalperiod <- lapply(evalperiod, function(x) ymd(format(x, "%Y-%m-%d"), tz=eval_timezone))
} else {
    evalperiod <- list(strptime(evalperiod, "%d.%m.%Y", tz=eval_timezone))
}
dir.meas <- ask.data(evalperiod[[1]])

### ...more details
firstfile <- fread(dir.meas[1], sep=";", header=FALSE, stringsAsFactors=FALSE, data.table=FALSE)
time.res <- as.numeric(firstfile[res.line,2])
use.multiple.cores <- FALSE
max.order.default <- list(p=2, d=0, q=2)
if (average.rawdat) {
    fixed.pattern.length <- floor(fixed.pattern.length * 60 / avg.period) + 1 - floor(fixed.pattern.length * 60 / avg.period) %% 2
} else {
    fixed.pattern.length <- floor(fixed.pattern.length * 60^2 / time.res) + 1 - floor(fixed.pattern.length * 60^2 / time.res) %% 2
}
if (is.na(tau.shift) | corr.shift==FALSE) {tau.shift <- 0}                                                      ### if tau consideration is switched off => tau=0

### details for filter application: adjust these for new spectrometers/gratings/ccd after careful evaluation
if (filter.type == "rfbaseline.smooth") {
    wl.window <- c(202.2,230.1)#c(202.2,230.6)
    filter.strength <- 0.13
    cutoff <- 24
}
if (filter.type == "doubleAVG") {
    wl.window <- c(202.2,230.2)                                                                                                                            ### wavelength window of evaluation: c(min,max) [nm] (from this, in case of moving average lowpass filter applications, the edge of the filter is thrown away in addition)
    filter.strength <- 27
    cutoff <- filter.strength - 1
}
