### initialisation
source(paste0(eval.dir,"/miniDOAS_packages.R"))
source(paste0(eval.dir,"/miniDOAS_functions.R"))
source(paste0(eval.dir,"/miniDOAS_rawdata_structure.R"))
source(paste0(eval.dir,"/miniDOAS_evaluation_param.R"))
source(paste0(eval.dir,"/miniDOAS_spectrometer_param.R"))

cores <- max(detectCores() - 1, 1)
if (!use.multiple.cores | Sys.info()['sysname'] == "Windows") {cores <- 1}
opt <- options()
options(warn=-1)

### wavelength/pixel indices
### ******************************************************************************
x1 <- which(f >= wl.window[1] & f <= wl.window[2])
x2 <- (x1[1]+cutoff):(x1[length(x1)]-cutoff)
x3 <- which(f >= dark.wl[1] & f <= dark.wl[2])
x4 <- (cutoff+1):(length(x1)-cutoff)