% The purpose of this example script is to demonstrate the implementation of 
% the Halo Doppler lidar background correction algorithm. The example data 
% was measured with a Halo Doppler lidar on 21 May 2014 at Hyytiala, Finland.
%
% 2 Feb 2016
% Antti Manninen
% antti.j.manninen@helsinki.fi

% Clear workspace
clear

% load data
load('example_data')

% Correct the background
snr_corr = correctBackground(snr,range,time);

%% Plot
figure; set(gcf,'units','normalized','position',[.1 .25 .8 .5]);

% for the histograms
bin_width = .0001; edges = .98:bin_width:1.02;
bin_centers = edges + bin_width/2; bin_centers(end) = [];

subplot(2,3,1:2) % Uncorrected SNR
imagesc(time,range,snr'); set(gca,'YDir','normal'); caxis([.99 1.01])
xlabel('Time UTC'); ylabel('Elevation [km a.g.l.]'); cbh = colorbar; 
ylabel(cbh,'SNR + 1'); title('Uncorrected SNR');

subplot(2,3,3) % Histogram of the uncorrected background, range > 4000 m
X = snr(:,range>4000);
hist(X(:),bin_centers);
xlabel('SNR + 1'); ylabel('Count'); xlim([.98 1.02]); grid on
title('Uncorrected background, range > 4000 m');

subplot(2,3,4:5) % Corrected SNR
imagesc(time,range,snr_corr'); set(gca,'YDir','normal'); caxis([.99 1.01]);
xlabel('Time UTC'); ylabel('Elevation [m a.g.l.]'); cbh = colorbar;
ylabel(cbh,'SNR + 1'); title('Corrected SNR');

subplot(2,3,6) % Histogram of the corrected background, range > 4000 m
X = snr_corr(:,range>4000);
hist(X(:),bin_centers);
xlabel('SNR + 1'); ylabel('Count'); xlim([.98 1.02]); grid on;
title('Corrected background, range > 4000 m');

