function [Y,Xf,Af] = neural_function(X,~,~)
%NEURAL_FUNCTION neural network simulation function.
%
% Auto-generated by MATLAB, 26-Aug-2022 09:53:52.
% 
% [Y] = neural_function(X,~,~) takes these arguments:
% 
%   X = 1xTS cell, 1 inputs over TS timesteps
%   Each X{1,ts} = 46xQ matrix, input #1 at timestep ts.
% 
% and returns:
%   Y = 1xTS cell of 1 outputs over TS timesteps.
%   Each Y{1,ts} = 1xQ matrix, output #1 at timestep ts.
% 
% where Q is number of samples (or series) and TS is the number of timesteps.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [-1.68999995366903e-05;-1.59999999596039e-05;-1.33000003188499e-05;-1.26000004456728e-05;-1.2800000149582e-05;-1.26000004456728e-05;-1.17999998110463e-05;-1.21000002764049e-05;-1.18999996630009e-05;-1.14000004032278e-05;-1.16999999590917e-05;-1.10999999378691e-05;-1.11999997898238e-05;-1.0400000064692e-05;-1.06999996205559e-05;-1.05999997686013e-05;-1.0400000064692e-05;-1.02000003607827e-05;-1.02000003607827e-05;-1.00999995993334e-05;-9.89999989542412e-06;-5.40000019100262e-06;-5.50000004295725e-06;-5.10000018039136e-06;-5.200000032346e-06;-4.69999986307812e-06;-4.90000002173474e-06;-4.39999985246686e-06;-4.60000001112348e-06;-4.09999984185561e-06;-1.0000000116861e-07;-9.99999993922529e-09;-6.99999986863986e-08;-1.0000000116861e-07;-1.39999997372797e-07;-1.10000001996013e-07;-9.99999993922529e-09;-1.99999998784506e-08;-1.10000001996013e-07;-2.20000003992027e-07;-1.1999999571799e-07;-3.99999997569012e-08;-1.0000000116861e-07;-9.0000000341206e-08;-7.99999995138023e-08;0];
x1_step1.gain = [1053.96289993394;1220.62861297572;1091.9414765104;1262.86546337841;1102.71821490546;1103.20482712738;1337.88213206509;1112.34706563871;1113.95791750798;1294.41456981587;1118.13046911451;1259.8425096483;1129.30546947113;1365.93360577538;1177.78690877419;1129.94349711371;1160.83347751544;1136.36360223748;1137.59169349366;1141.61767799091;1148.30336082484;1433.79455087743;1365.46728303767;1530.45605639455;1447.59698560134;1671.54200528645;1597.06146786296;1918.46524950303;1762.73578198116;2310.53609170957;40184.8492469015;36114.1199272559;19737.4919724976;35007.8768451598;20650.4907449023;20889.9103642965;32835.3298999127;61068.7015731092;21891.4176992544;21503.0650144559;36690.5163829394;41186.1615885709;25034.4225527092;42589.439463744;24761.6692838396;0.000307893622753339];
x1_step1.ymin = -1;

% Layer 1
b1 = [5.1056390119348380452;-48.507954264265563893;-1.0502087810228024622;-0.17479303204322177434;-5.5781321349694694689;-1.7843798085314743762;-5.4396079437808122492;-3.1267202039772348243;-2.550001231855253625;-0.94773581981282395414;-1.2989493139219225881;4.2485757691090633159;7.6474973010683209296;-7.2113935131415267676;-2.1011148830127734932;2.6392850361881463606;-8.2339097864130064153;-0.87362164298205191582;7.2159618322824519154;2.8793183861680877733];
IW1_1 = [-1.1728820131787862646 -5.3454884819993431222 -0.071595062689517541266 0.52924558538708876831 1.2653952051349788288 -1.7421244411432090793 4.7658928656975385607 0.13939469855674421761 4.1947621154885261774 -1.6560496287256594172 -0.74001057389133539921 -4.2898263150129700705 2.589358260125228739 -7.6427758482802996554 -0.91480408069861007814 -2.8534805158705345285 -0.071275436666275088227 0.95328440639427414194 2.0149707465458908118 0.593939434742822292 0.41135045801981717783 -0.4671375840548434577 1.5980550961374857533 -0.012070008434541493192 5.3377391898407822168 3.3988647819374206982 -10.155477822408085942 0.29942366554254462585 3.970483027504921214 -1.1341183937786740721 10.229387546962410482 -4.7009571930643483384 3.3401983215079202871 2.4848131859815469902 -0.9058427086650001625 -3.5088588958856909983 -5.6622337777296527506 4.4294940939935347757 2.1434335117862657327 0.79455202225042254049 1.865634679991593492 2.6562805639612068198 -3.9945473624370402277 -1.1022717572147817666 0.92913400629810749543 0.21148030464546510587;9.8098023978612012286 7.6491324405369374162 1.2862130726560694338 7.287511738877779699 -0.50047094622766630234 4.5608817538410599823 7.7668785427127851051 -0.51810327400193090241 -8.5291138719396499823 2.0072889319826474619 -3.5751025138309451279 -10.341745485355824385 0.50047468457375376971 -1.0668315640092118635 -2.8650838089772423523 -5.8222298123911926382 -5.5099839320413108723 4.0452746182381291717 3.7597469434077166461 -0.92623155927437217372 1.6608694640453243174 -1.7117189607952003616 -0.75823212771501335983 -2.3172728912827866843 0.70112196803150927948 4.6262424809089912614 0.13289969129176684715 1.4261412688863328579 2.0434783524158133261 -4.7434414406991507462 5.4176361166947062387 -9.6430516327263546827 -2.7109212742209423119 -6.9301545121649690273 -6.2066398306734127388 2.9180900721076521442 2.6661343989507675367 1.7679356860403199203 0.88883134130355379021 2.4271514036532746417 2.697017764033200482 -3.0493902436202002804 -0.63582996091654320203 1.6710346237041628914 1.2318796873977244655 -40.804825281839981699;-4.1178145430555073148 -2.0166118912297044119 3.8557410462770036474 -0.49237520862752420792 0.063045695729157746889 4.6764901331259185469 3.1675303653094948331 5.4072870238645940333 1.928863614407229532 0.25789965772401945987 0.60095580086644573292 -2.8080937988736835997 1.1906051967114004153 0.53464269046775103611 -2.1803578412497555128 0.6745674637295565601 -3.4881125741751612956 -0.55984587379987194034 -2.1615129544454849686 -0.46200466005173568274 -1.5413937915772966125 -4.2142645495153709945 -3.9000958040757520706 1.027598390247175697 0.095085210093143454624 3.4174105972604844617 5.7810070264028130538 -1.4592533124341335871 0.58676641886851277352 -1.7823358080915405743 1.5250461159340089612 -2.0712374235922323962 -1.4860992223360049991 1.1795956415724566657 -0.65799630156338695386 -2.3375474353288385743 -0.42137678932278643806 -0.27996660928945510394 -0.80448508009890762338 4.5160632542265073397 1.9388694441728766549 -1.829241724407820735 -1.9279562996044290468 0.35733883018566531264 0.29873520943232717562 -0.45593207664227691778;-9.6632068030530504643 -5.1857634997322374915 -2.8212072230910076875 -4.7702287064506938563 -3.1753349828134793675 -1.9259968540462213404 2.7020543080445946771 -2.465547522619471188 -4.2380126037267169536 3.3516490904025966202 0.095735195038943940449 0.17740270884920295025 3.0931523300737899795 -0.78587135090482318489 0.28088137594244855233 1.4777552104567708291 1.2107533321380967717 3.6149168491719785301 3.0792645256786084218 0.43283309692074761754 4.1145631755553271347 -0.026700691694983264002 8.3742776467875224 -1.8169387536129388838 4.0744428444759304142 0.74065828576135994687 0.31652337400852925686 -1.0481393744189768658 1.1563446442017051297 -1.8773805113925139398 3.1101256951790592353 0.46917172647484184367 -0.28642357349464181437 -0.005299368684285370168 -0.68144436684755715916 -1.5986990289607290183 0.081349137058196768768 0.20522022723570362834 -2.3971857724195548833 -0.15399435004950057237 0.85387712132484028249 -0.52122012887494195699 0.051448047487295360536 -0.37278101505487826195 -0.062009582315644400097 -0.20934884807252909789;9.9816638605664316231 4.3380390209489680942 10.178311077056466871 -3.3867795181316586728 4.6356501315612534952 4.8580341871946899346 -0.55627459682058777446 4.9107466487030357882 3.6057305676371234071 -3.6919008173631322478 7.0007179551567970677 -6.7442120378844121475 -0.72812341141035485936 -3.4858516604524760751 -3.7137564756308383274 1.4295726457853292768 0.64332314624615072329 2.3670350221162070881 -0.61714600169363442728 2.6981762344379291996 0.099878846117963937523 -5.2539620749713185077 -26.585777506581145246 5.7042573150508024682 -13.809838651762332162 2.2076815424549778299 -0.90908810906171266808 0.49092306230405519107 2.0164819323575251531 4.2610308476279374901 1.5678860631044975182 -5.9583191423174897139 -1.4717051617393803742 3.6989313051365844132 -8.7425129493026645378 0.051360623968520729976 -0.75158184977694075801 0.24868522024688188843 -1.6554683347763523571 2.7224129170814159728 3.1128217759074878757 3.58314888596549741 -4.3037501775572621909 -0.36271529128468854575 1.512297786471707095 -0.2462967194195625209;-5.3628691147380713744 -1.1727364938210895762 0.97317162748774477254 2.1560702879971036516 4.8813881616960026477 3.4234856281745584816 3.0807298042543265204 9.8961680269054390635 0.71774687186257946081 -1.7158919295267534011 -0.63402582877927937677 -0.060972955379672733045 -4.7756639641026712439 5.2672939916452214959 1.0974243392478615355 2.8448670409282437177 -2.792353009186638868 -4.1797949214227863024 -6.7021387494941517815 -0.12005221441316712983 -0.92664133813894267178 0.19938783161014014822 -7.9837832728396209703 8.5523743123849058634 -1.8874777077771280887 5.8356923008797672026 4.982805258759396061 -1.0614028078458244142 -4.6293752633559721588 -2.8029839661991702293 -1.8946253835298569879 -1.0819871964000564724 -2.5136605621618461903 0.71492400154505986176 0.65077734290043898202 -0.89480519930529400785 0.21829458327229894765 -0.3565253176644421762 1.9907060300146395271 1.3503065618849323659 -1.4458274890699087667 -0.18286373256193538817 0.069318423823567509867 -0.32914758324589693528 -1.7782077945855301326 0.059878620112359240424;7.4238839807163614637 2.8021384024191950957 7.4586460411658785929 1.3601132503493342796 7.4120303015356068244 5.9796014158375720982 0.1372771901065873712 4.2987567181100159175 6.7022145223695739347 -3.5417363708246636378 2.8881052096400789964 -6.1107380591963762484 3.2875682387389653094 -3.9660027779868500808 -3.6764303481700517651 -0.15377493522275889615 -1.1239348209707236137 -0.3389779464387492891 0.77135025512055566121 0.31675720884573077551 -0.93241248632546325226 -6.0270709721496134037 -20.55519855425702147 3.2725045898237459241 -12.521584689736688034 3.9175260662462871863 0.49244509328351038224 0.82648881823859987605 2.5482704242272826711 0.77269382447033130301 1.4775091678463614375 -4.2341005655500270066 -2.0106109427898966047 1.5706557746138305465 -3.8290908961874428051 -1.4572838425380056915 -1.5840373756444341424 1.9831299771189696557 -1.6696659888336746747 0.50112744703928757684 2.4807328025910559965 2.3951056163422972389 -4.9493247797287516221 0.71261223077509372459 2.2146087141662236242 0.029038121116511366598;10.441051161894314703 1.2230970919597137225 5.0168887519216225357 -4.5803129490536704793 4.9696329900105906674 -0.5864612682041547842 -7.1027466577011590942 -0.61862765493091198543 5.0721649763489242702 3.7685087273196762325 0.38632951504171247903 -1.726357068163803854 -0.43657919592105942641 -4.1040671820594569752 0.85549451492391548335 -4.2647487907444610045 4.0116782782088540316 -3.6212062612516016102 -1.6950844837277738719 -10.926745291447865327 -0.40199438986798374795 4.2493811419166034327 -1.5949309088823477865 6.445364306414532507 0.62194751226872357908 2.0041408275022565277 5.07482659073545328 -2.1317701539385938148 -2.227906086858898238 -6.7502989826815227303 -2.4921861651686678663 3.8880928369145024703 -4.2186289977398860884 1.1040388259107589697 -2.6140206282325366693 -1.3538685299396511219 1.4158027731250295567 -1.2603094987191867382 -3.8707614004128663154 -5.5761103974663805971 -1.5524928789857279643 -1.7901425061758304835 5.0232519742643049199 3.5124359052836005013 2.9533137973761314221 0.060690203011222812468;8.1488426924104491178 2.4693868277259229949 0.36838717347943705782 -5.0148773309376615259 1.5069796307565799243 -0.47803915248363210155 -5.7697670938670704288 -0.55212009763823233222 0.51480983301666960461 3.4334316544310867769 0.1459734580158805195 0.70978769409409125934 -1.0400224284992054535 0.36835807112768564897 0.4377316492487081101 -2.7289304182444524827 2.7828751310427439769 -2.6566219091461902302 -1.6829036057366300039 -7.0964664755354656123 -0.12832990702040936171 6.2956724235882033369 1.5531817933357114914 4.024901830134010261 -0.88485399469354408808 -0.93836369830419918969 5.4101259287243070872 -1.3363638199735943246 -3.688528252160430565 -4.1952798766082919357 -4.5475359851766654629 4.5760335088202692688 -3.2995334795377742054 -0.22387500715223249137 -0.8305208328018383046 1.886246294146707303 3.8417710872989232485 -1.1214905224311864096 -3.26279333120904802 -5.1104417365107259741 -1.8059322461515696645 -1.5186780442693756932 5.1628424059875959173 1.2441710327008939085 0.4314496366331229682 -0.51777997402979458741;2.3070290693452184527 -2.3872122480602939731 0.7444297906202985704 -7.6368055882541163726 -0.85366908104664562806 -1.0235708862888686088 -8.811695746307631083 -2.9304654088047330518 -1.0198497490800295662 -4.4255281376549175931 1.3350257567806187442 -2.0425960518165533486 5.8838955017159637606 2.1806698989149602141 4.0835602231846168664 6.5838052580091375177 1.8915677577052167901 4.2745582884500512577 3.773172671678505008 -0.20497975172121965515 5.9326375424865540609 -2.3167209137683393294 4.6197027787284410394 -2.4720924276605948933 -0.25129719590560195552 -0.79562198321895549746 -3.2639085091023711804 -0.32162260637356221427 6.6147333104752368271 -1.2209904544349179378 2.7229418448964426425 -2.3350782473403230988 -1.4452970025611633353 0.8867657472239581784 -6.5429732147250554419 -1.1208729526606704407 0.37395956008637837309 1.2852222933755617085 -1.3480254220974667856 -0.28839841454694870038 1.0698361850153856878 0.043061346741962519546 -3.8631463938990564522 0.88517133347242549224 3.3665955704629757506 0.10451562025978064496;2.3322794628149656759 -5.2833626415762102724 -0.57152791212053533076 3.4083212125843642681 5.4381625538216118443 0.31996868622598734211 1.2462949582550988392 1.7736887295476455595 4.9751875678083044008 2.4325168359319548905 -3.3000969543832119335 -5.406555153569663652 5.8092402966568350564 -4.9131171887466296155 -6.0317272087611844 2.7845280809808490297 -5.5395665920812859895 0.31752268920612358727 0.74474045947197520245 2.2561605204697476879 -3.8773340714249515671 -3.6913779592012487818 4.4440229410828226975 -11.991396609392147354 1.1691248221956294095 -0.55214119606165812382 -1.0544523762544810719 4.1221916945757044459 8.0817387188268074993 -0.079343755874826393804 3.5744693437746200004 -5.7701896164040089587 0.33176186131664986423 0.1246119488551944432 -6.5016907710866203018 -1.5271332726078339359 -5.927122103639556272 4.0292909439072159827 0.63926446185316732063 7.3357272607682029175 -0.48162881360617959547 1.7317653371787837813 -1.8856236023888441888 1.5629196918093459789 5.4822947185991823815 -0.92448542736124772468;-3.5475759100577635152 -4.3320367535727370978 -4.7493287059175912646 1.4672218973254878005 -1.9859751036142962999 -3.5172708543589457086 -8.2685219835335725946 -4.63597701402012774 -1.7094958866271543485 0.25331640636722618787 -4.6819684353896109386 6.5927476532462394587 2.656212550593089361 -5.6937658280800569344 3.5282436695726993037 3.9945705211432955828 4.5283552163020921455 1.7669574174390658694 4.233883535030130929 3.7385510077624615199 0.67069835177395686898 0.29565331570119812721 6.6418268840096308381 -5.3000038704391538857 -3.3948594947877763772 -2.4878115733839960555 -2.6654752717923169136 2.6777198573155849282 -0.023875435139239800653 3.7437116407758912473 -3.1934825895512144456 8.0174800831398691514 -0.64512507809620234234 3.8031713198205565618 1.8875977725588286571 4.7667062567048965604 1.8622578225977801658 -2.2689403888262220654 -0.73674201101291969529 -2.6354173222435743895 -5.0031133119145154708 0.36852797378820645324 0.43179022227321428584 0.24634169483511048071 -1.7889070107709423851 -0.8051660058737528658;6.0904702049370351702 5.8686499534966003466 -0.53740908719165514373 2.4564351321294108921 -1.9641027211293879962 5.7760709703984858265 0.083563011371688547535 0.078837431044383995959 -0.22305595931294674994 -6.697163776329855267 -1.1769103315675533139 1.5538662859882093059 -1.5649417359376971426 5.1950631816033521204 -1.2860783722256610151 -3.8897591838840770428 -4.9584688466090742764 -1.1922163636768638995 -0.65966076983624910568 1.9351369803258136049 -3.2593727557352156765 -2.1819851874531450697 -4.8021750572464778628 -2.4042735318146282175 -0.85609209410205200363 -4.363606268627760798 6.08794232720715911 0.70617912528630999436 3.2777042182228215417 1.1650335543680434558 -0.046323506231225844432 -1.8319468979345057136 5.3649214987585640557 0.99992547457664970878 4.2428409365349546434 2.2883229272945051491 0.52171860372084422064 0.75562657304342850662 2.7007390053789088746 10.373196516620172503 0.70326896834981056372 -3.5210036810674854024 -3.8333662152182537142 -5.4498424191991903243 -1.2988816814306478609 -0.70943238838111322142;-1.2740219146854456778 4.9245587451406853674 -0.18843436662959461847 3.3498187648796378113 4.2673039298379293882 -4.0461551412655625271 0.29448399705291938844 -0.20386451358234855546 6.6816372977017373103 -0.066712532442656513609 2.446204130582279479 -8.9359463620636390147 8.0061900524892841702 -1.8957243471850173666 -2.6140309100770400264 6.0208821646697359142 -1.9839561626197161903 0.24906245757117681516 3.1321918210878076927 -0.3322265752440217712 4.456715199720783005 -5.2545762509894329284 -7.0865883115593648611 0.35573583848668682839 -10.844840849070036981 3.7664707880445082999 -1.8505044325878130529 -1.1310302854487357394 10.147399527049584478 -3.5404912914831814241 1.0798092185491543482 -3.5735371426730915267 -2.6187135683492877014 1.9760708573509591091 -3.9048993352943548452 -4.6298181910702904673 -4.0639718642046700481 1.1755481140971340004 -3.8404623515742013495 -1.2353174865934231086 3.4327671368187462342 3.8440626516944420565 -8.1824459679785110922 1.6222862760989487096 6.9208512197562175317 -0.067513925663466173299;2.4651677806156406803 -6.3754526297320435191 -1.1520650716715332695 -6.6054305646431652477 -4.50333510848587526 2.4113383673339887636 -4.0976099865088757568 1.6451212888989157346 -0.44000814998649412368 -1.9342251751709178542 -0.89977833881269253524 0.92165109276431733676 5.9573419044505468989 0.97136185495008109392 -0.41389715852995445644 2.1639584051313081048 -3.6742231191904743959 1.291602911556622324 -2.4435854065078772557 6.4270197886631814654 2.8045865400152942826 -0.70251758846367462485 2.7343984804908094688 -0.87831336478992783068 -1.4852649307364442777 0.10748245234818498695 3.3232500867307783743 0.17647963078173778406 3.5520351240378400526 -0.64748372664214215444 -0.23914940289187430755 8.8896816413437313997 -1.661591801934132695 3.0554039157509333968 3.5645272984145681683 0.96650328511489647099 1.4030389892647989747 -6.435307047883672027 -1.0913382313302444349 -1.67783090253158651 -3.5463089423499378761 -3.2889655888405844308 -2.9734637690018046463 4.0156816262590933064 -7.0744899804242038499 -2.4249475879052666549;23.681910428845714733 2.4432060825176011853 12.158463005328254525 0.40404737222941766728 8.9390196941091293326 4.7547877199448507213 -3.4165170374393398767 1.975575980559404643 1.407207646365092657 -7.0224176478971545023 2.5452040230121455444 -8.5783768349741080783 0.97587134921521800912 -8.5297654336723791602 -3.6511036686760660608 -3.214833508605321466 -4.3037256110649790841 4.9564036993195257352 1.3518235567649112827 -1.0640139407464273003 -8.5749485836621293089 -5.0887462419216351606 -11.686859157083361538 -0.54028695472750010165 -11.001412582914820604 1.4737941524581845698 -3.1855186064615423902 1.5941865267080970181 4.47891444633646163 1.1024873708385316551 2.546681096071822914 -8.5984050685508197631 -5.7661840793644412173 10.32367675280373831 1.0470662217435562358 -2.1475669164727011484 -5.1934337201375608828 3.2286894813038546914 -6.0066161939037510109 -5.3764984182900237286 2.7406534480121167441 4.9318841376433386614 5.0793115348045638768 1.5330942327247416568 5.2941232134320292957 2.774313908152530761;7.686662906341257262 -8.9782477057049501212 9.3741426273593955187 -13.794394494522668637 0.9817189395563318266 2.8228641649613122055 -4.4059289924559061902 4.7704668440011204211 2.8265035664031810114 -9.0687696617421877932 2.8037560175383959837 -10.488161674279586677 4.8310694345257738647 0.373045849792938089 -6.4165082940663928923 15.963531027636818749 -11.293653126710376355 5.0145013699512324123 7.4015919201805546734 5.605690491577759893 1.1851212510230018093 1.1774964090108899217 11.410833526285745876 -10.024340681310514256 -0.59560053250519784385 5.6617133494524463089 -6.33730521037738459 -1.2648481472878172482 10.136103336677834363 -1.0828760216008461725 6.9112867748100388354 -6.5202405654322062034 -13.823134083762807833 20.727995515753335098 -11.539499025078036709 -13.396680980513387738 -9.3392514608717629443 -4.1836025925409465742 -7.9699184025637999085 -16.791855709756219994 2.6541874745568954097 5.3967851294802011708 11.008927417131644688 5.6247649633601586316 6.9969763034500429555 2.6918408156011870425;-3.5564902878629713889 -8.3626044106069521433 -4.576924004413075231 -3.6736686789912509354 0.11625059597743374329 -5.3799465935249948245 -0.83952244831168287842 -2.7901598328258874204 -3.3649506455282498507 5.464779271587834053 -1.1385126911024010532 0.090438610424490473161 3.9349133645920875146 -1.4976686500142915026 -0.58237811420011442731 0.26057160961201347726 -0.56168909379097975432 3.1121673464042571844 0.015232297559272547222 1.41141245843640184 2.7029685553219335858 2.1892083206596124612 14.5120117645501292 -9.6697794402999548424 9.2762649352096673283 -4.2908187944315532292 -3.7226511429958066834 2.8266298963268234878 6.756555922301296313 -0.61130772546637945908 5.2296623376704269859 -2.2937248507028527023 1.1462766263563948232 -0.75287797408255296983 -5.1930551193119089959 -0.056073449273778136481 -4.4264483579797708757 2.0559999632864345287 -1.3294763525396968706 1.697903238248237523 -1.0136345238678519109 2.3855665798523153498 -0.48148624481495050365 1.1715321427555480671 1.9652394858926729437 -1.1597933234562598503;-1.892365866211329184 -1.6986370030522239816 0.93037501942253775233 -2.8218435589554480281 3.8455428000027578328 4.7464235421178084806 -2.8989683602389644257 1.0496687598322496093 -2.3234056629322759058 -3.7022171716135185981 1.5576319903882067663 1.2466797429411140552 -1.2071901095771422341 -1.4938930408970347852 0.98330332055666769264 2.7505717216437619577 0.85949617011507206676 -0.051369888815459875675 2.5156651382347914314 1.8385702001145709517 2.6574554380588151226 1.3823142709961036001 -3.0245289197278180104 3.9502118675940702808 -3.3144786661052254573 0.79343490625526968962 2.7149975256812624025 -1.2690265622211738261 -0.73812778294848868654 -0.57158211819271098619 -3.2172457877028901585 1.5675178470628796656 1.1597831893908505663 0.72549094607492903286 3.1187197586175776642 1.5423149810478704591 2.3992819492333490317 -1.9361235199239845706 0.085206800937705662324 -0.4556161182505756857 -0.70579858233051862015 0.2240211097203090862 1.070274660164442615 -2.484480454792226567 -2.0343344548971518115 0.67077002161116350276;-7.6101928593861334349 -5.1286646598313589962 -4.0365580019187881078 -2.4290598255436046671 1.1842331352585651061 0.08805054262217973382 9.5353040620947187023 -0.84999022581477090554 0.99586145657839364453 2.5069276567455078819 0.20030448045474341656 2.0606594212789577369 -1.5269857162064670586 1.0403383962497076975 -5.8291103024473338579 -1.1878720731993923643 -1.0673255698980603778 -3.3922269528166069108 0.41964273767998067077 3.0433618325017541828 1.0595800180701802073 3.0439597918195668846 -0.54363816471911652339 1.8899851320700713497 0.47036965278537928858 2.8188839984238187597 -0.89460166062297941103 -1.0017062303812598323 -5.2741372997635922459 1.0153250681151408941 0.60247017654848178392 3.7817099078879170548 2.352667170401041119 -0.32371326791764559738 6.8568464703456122322 -4.5606295506630827319 -1.6456763408839507612 -0.99280598923237484144 2.3779883406685651259 -3.9671424213295871652 -0.03895096953751531893 0.14748095347354775453 3.9025192735358924523 -0.51219245927980716626 -2.7279486649454534053 0.38499777896762782392];

% Layer 2
b2 = -10.464297584162871146;
LW2_1 = [11.004429845713058711 27.98019974287385736 30.628048264320081984 -31.456054014886511538 12.453339030568047363 -17.142576120222894787 -25.72364754032572165 -15.621499297677207352 24.707208732608155088 21.61962055383938619 -15.128593522252618442 15.075102156258717301 -13.492245533007061198 9.7009636498967584117 -5.2692604584198150519 6.5239068241889652811 -3.9447427420152325617 16.496779300127570878 29.54016472358113532 19.597666239386171583];

% ===== SIMULATION ========

% Format Input Arguments
isCellX = iscell(X);
if ~isCellX
  X = {X};
end

% Dimensions
TS = size(X,2); % timesteps
if ~isempty(X)
  Q = size(X{1},2); % samples/series
else
  Q = 0;
end

% Allocate Outputs
Y = cell(1,TS);

% Time loop
for ts=1:TS

    % Input 1
    Xp1 = mapminmax_apply(X{1,ts},x1_step1);
    
    % Layer 1
    a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*Xp1);
    
    % Layer 2
    a2 = logsig_apply(repmat(b2,1,Q) + LW2_1*a1);
    
    % Output 1
    Y{1,ts} = a2;
end

% Final Delay States
Xf = cell(1,0);
Af = cell(2,0);

% Format Output Arguments
if ~isCellX
  Y = cell2mat(Y);
end
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
  y = bsxfun(@minus,x,settings.xoffset);
  y = bsxfun(@times,y,settings.gain);
  y = bsxfun(@plus,y,settings.ymin);
end

% Sigmoid Positive Transfer Function
function a = logsig_apply(n,~)
  a = 1 ./ (1 + exp(-n));
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
  a = 2 ./ (1 + exp(-2*n)) - 1;
end
