#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Feb 14 14:04:03 2024

@author: zhangshuai
"""

import numpy as np

def calc_rgf(z, az_idx, bin_idx): # 计算反射率梯度标志
    left = 1
    right = 1
    up = 1
    down = 1
    
    if z[az_idx][bin_idx-2] > z[az_idx][bin_idx-1]:
        left = 0
    if z[az_idx][bin_idx+2] > z[az_idx][bin_idx+1]:
        right = 0
    if z[az_idx-2][bin_idx] > z[az_idx-1][bin_idx]:
        up = 0
    if z[az_idx+2][bin_idx] > z[az_idx+1][bin_idx]:
        down = 0
        
    return 1 if (up+down+left+right) == 4 else 0

def calc_rd(z, az_idx, bin_idx): # 计算反射率差
    if z.mask[az_idx-1][bin_idx] and z.mask[az_idx+1][bin_idx]:
        rd = 50 #np.nan
    elif z.mask[az_idx-1][bin_idx] and ~z.mask[az_idx+1][bin_idx]:
        rd = z[az_idx][bin_idx] - z[az_idx+1][bin_idx]
    elif ~z.mask[az_idx-1][bin_idx] and z.mask[az_idx+1][bin_idx]:
        rd = z[az_idx][bin_idx] - z[az_idx-1][bin_idx]
    else:
        rd = z[az_idx][bin_idx] - np.ma.min(z[az_idx-1:az_idx+2,bin_idx])
        
    return rd

def calc_swr(w, az_idx, bin_idx): # 计算谱宽比
    if w.mask[az_idx][bin_idx]:
        swr = 40 #np.nan
    elif w.mask[az_idx-1][bin_idx] and w.mask[az_idx+1][bin_idx]:
        swr = 40 #np.nan
    elif w.mask[az_idx-1][bin_idx] and ~w.mask[az_idx+1][bin_idx]:
        swr = w[az_idx+1][bin_idx] / w[az_idx][bin_idx]
    elif w.mask[az_idx+1][bin_idx] and ~w.mask[az_idx-1][bin_idx]:
        swr= w[az_idx-1][bin_idx] / w[az_idx][bin_idx]
    else:
        swr = max(w[az_idx-1][bin_idx], w[az_idx+1][bin_idx]) / w[az_idx][bin_idx]
        
    return swr

def calc_w(w, az_idx, bin_idx):
    return w[az_idx][bin_idx] if ~w.mask[az_idx][bin_idx] else 0 #np.nan

def calc_zdr(zdr, az_idx, bin_idx):
    if zdr.mask[az_idx][bin_idx]:
        zdr = -8 #np.nan
    else:
        zdr = zdr[az_idx][bin_idx]
        
    return zdr

def calc_ccd(cc, az_idx, bin_idx): # 计算相关系数差
    if cc.mask[az_idx, bin_idx]:
        ccd = 1 #np.nan
    elif cc.mask[az_idx-2][bin_idx] and cc.mask[az_idx+2][bin_idx]:
        ccd = 1 #np.nan
    elif cc.mask[az_idx-2][bin_idx] and ~cc.mask[az_idx+2][bin_idx]:
        ccd = cc[az_idx][bin_idx] - cc[az_idx+2][bin_idx]
    elif cc.mask[az_idx+2][bin_idx] and ~cc.mask[az_idx-2][bin_idx]:
        ccd = cc[az_idx][bin_idx] - cc[az_idx-2][bin_idx]
    else:
        ccd = cc[az_idx][bin_idx] - min(cc[az_idx-2][bin_idx], cc[az_idx+2][bin_idx])
        
    return ccd