#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Feb 14 15:10:47 2024

@author: zhangshuai
"""

import numpy as np

def limit_region(radar, sea_flag_radar, z_thr=20, rg_thr=130):
    # 限制反射率和距离
    z = radar.fields['reflectivity']['data']
    id_region = z >= z_thr
    id_region.mask = 0
    id_region = np.array(id_region, dtype='uint8') # 原始场为mask类型
    end_range_index = np.where((radar.range['data']/1000) > rg_thr)[0][0]
    id_region[:, end_range_index:] = 0
    
    # 仅在海面识别
    id_region = id_region & sea_flag_radar
    
    # 满足局部唯一最大值
    for i in range(radar.nrays):
        for j in range(radar.ngates):
            if id_region[i][j]:
                a = i - 1
                b = i + 2
                c = j - 1
                d = j + 2
                
                if (np.ma.max(z[a:b,c:d]) != z[i][j]):
                    id_region[i][j] = 0
                if id_region[i][j-1] or np.any(id_region[i-1][j-1:j+2]):
                    id_region[i][j] = 0
                    
    return id_region