#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Jan 25 17:20:57 2021

@author: zhangshuai
"""

import numpy as np
from numba import njit

def read(file_path=r'sea flag.txt'):
    with open(file_path,'r') as f:
        lines = f.readlines()
        
        col = int(lines[0].split()[1])
        row = int(lines[1].split()[1])
        x_start = int(lines[2].split()[1])
        y_start = int(lines[3].split()[1])
        resolution = float(lines[4].split()[1])
        sea_value = int(lines[5].split()[1])
        
        sea_flag = np.empty((row, col), dtype='int16')
        
        lines = lines[6:]
        for i, line in enumerate(lines):
            sea_flag[i] = np.array(line.split(), dtype='int16')
            
        is_sea = (sea_flag == sea_value)
        sea_flag[is_sea==1] = 1
        sea_flag[is_sea==0] = 0
        
    x_end = x_start + (col+1) * resolution
    y_end = y_start + (row+1) * resolution
    x = np.arange(x_start, x_end, resolution)
    y = (np.arange(y_start, y_end, resolution) + resolution)[::-1]
            
    return sea_flag, x, y

def cartesian2radar(radar, sea_flag_cartesian, x, y):
    lat, lon, alt = radar.get_gate_lat_lon_alt(0)
    sea_flag_radar = np.empty((radar.nrays, radar.ngates), dtype='uint8')
    _accelerator(sea_flag_radar, sea_flag_cartesian, x, y, radar.nrays, radar.ngates, lat, lon)
    
    return sea_flag_radar

@njit
def _accelerator(sea_flag_radar, sea_flag_cartesian, x, y, nrays, ngates, lat, lon):
    for i in range(nrays):
        for j in range(ngates):
            if (lon[i][j] >= x[-1]) or (lon[i][j] < x[0]) or (lat[i][j] > y[0]) or (lat[i][j] <= y[-1]):
                sea_flag_radar[i][j] = 0
            else:
                jj = np.where(lon[i][j]>=x)[0][-1]
                ii = np.where(lat[i][j]<=y)[0][-1]
                sea_flag_radar[i][j] = sea_flag_cartesian[ii][jj]